#!/bin/sh
#---------------------------------------------------------
#
# PL-1 MQ Cluster (for Requester)
#
# Parameters:
# $1 : Queue manager name
# $2 : Number of connections
# $3 : Messages
# $4 : Message Bytes
# $5 : Log Directory
# $6 : Workload
# $7 : MQ Constant
# $8 : Data File
#
# Environments(./runpfmts.ini):
# $INCL_CON_TIME      : Include MQCONN/MQDISC time in measurement,
#                       0:not include, 1:include
# $RCV_BUFF_SIZE      : Receive buffer size
# $CON_RETRY          : The number of connection retry
# $CON_INTERVAL       : Connection retry interval
# $PL1_RequestQPrefix : Request queue name
# $PL1_ReplyQPrefix   : Reply queue name
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#
#---------------------------------------------------------
# return code
RET_OK=0
RET_NG=1

USAGE="$0 <Qmgr> <Connections> <Messages> <Bytes> <Log Directory> <Workload> <MQ
 Constant> <Data File>"

if (( $# < 6 ))
then
  printf "\nUsage: $USAGE\n\n"

  cat <<-!
    PL-1 MQ Cluster (for Requester)

    Parameters:
    \$1 : Queue manager name
    \$2 : Number of connections
    \$3 : Number of messages
    \$4 : Message Bytes
    \$5 : Log Directory
    \$6 : Workload
    \$7 : MQ Constant (ex. MQPER_PERSISTENT, MQPER_NOT_PERSISTENT)
    \$8 : Data File (Input message file) (Option)
         If not specified, "<workload name>" is used as the message.

    Environments(./runpfmts.ini):
    \$INCL_CON_TIME      : Include MQCONN/MQDISC time in measurement,
                          0:not include, 1:include
    \$RCV_BUFF_SIZE      : Receive buffer size
    \$CON_RETRY          : The number of connection retry
    \$CON_INTERVAL       : Connection retry interval
    \$PL1_RequestQPrefix : Request queue name prefix
    \$PL1_ReplyQPrefix   : Reply queue name prefix

!

  exit $RET_NG
fi

# source environments for performance test
. ./runpfmts.ini

# import library
. ./lib/libpfmts.sh

TARGET_QMGR=$1
Connections=$2
Messages=$3
Bytes=$4
LogDirPre=$5
Workload=$6
MQ_Constant=$7
DataFile=$8

TRM=""
SFILE="syncstart"
SRF="-sf ${SFILE}"
if [[ $INCL_CON_TIME -eq "1" ]]
then
    TRM="-tr"
    SRF=""
fi

Counter=1

LogDir=$LogDirPre/${Workload}_${Bytes}_${Connections}_${TARGET_QMGR}_`date "+%Y%m%d_%H%M%S"`

mkdir -p $LogDir

LogNamePre=$LogDir/req

((Total_Messages = Connections * Messages))

if [[ -f $SFILE ]]
then
  echo "delete $SFILE file for synchronization start."
  rm -f $SFILE
fi

while (( Counter <= Connections )) 
do
  echo ""
  echo "Start Requester Program, Put ${PL1_RequestQPrefix}${Counter}, Get ${PL1_ReplyQPrefix}${Counter}"
  # Requester
  # secondary side: MQGMO_ACCEPT_TRUNCATED_MSG
  if [[ -z $DataFile ]]
  then
    ArgumentListReq="-qm $TARGET_QMGR -q $PL1_RequestQPrefix$Counter -m \"$Workload\" -iq $PL1_ReplyQPrefix$Counter -rq $PL1_ReplyQPrefix$Counter MQMT_REQUEST $MQ_Constant MQPMO_NO_SYNCPOINT -n $Messages -l $Bytes $SRF -cr $CON_RETRY -wp $CON_INTERVAL $TRM -ss -sz $RCV_BUFF_SIZE MQGMO_WAIT MQWI_UNLIMITED MQGMO_NO_SYNCPOINT MQGMO_ACCEPT_TRUNCATED_MSG -mc"
  else
    ArgumentListReq="-qm $TARGET_QMGR -q $PL1_RequestQPrefix$Counter -f $DataFile -iq $PL1_ReplyQPrefix$Counter -rq $PL1_ReplyQPrefix$Counter MQMT_REQUEST $MQ_Constant MQPMO_NO_SYNCPOINT -n $Messages -l $Bytes $SRF -cr $CON_RETRY -wp $CON_INTERVAL $TRM -ss -sz $RCV_BUFF_SIZE MQGMO_WAIT MQWI_UNLIMITED MQGMO_NO_SYNCPOINT MQGMO_ACCEPT_TRUNCATED_MSG -mc"
  fi

  echo "mqpgf $ArgumentListReq"
  nohup mqpgf $ArgumentListReq 2>&1 | tee ${LogNamePre}_${Counter}_`date "+%Y%m%d_%H%M%S"`.log > /dev/null &

  printf "start background: %d of %d.\n" $Counter $Connections
  ((Counter += 1))
done

if [[ -n $SRF ]]
then
  echo "create $SFILE file for synchronization start."
  touch $SFILE
fi

flag=0
while :
do
  ps -ef|grep -E "mqpgf.*$TARGET_QMGR.*$PL1_RequestQPrefix.*$PL1_ReplyQPrefix|tee.*$LogNamePre"|grep -v grep > /dev/null

  if (( $? == 1 ))
  then
    printf "terminated."
    break
  fi
  sleep 1
  if ((flag == 0))
  then
    printf "Waiting for the completion of the test process."
  else
    printf "."
  fi
  ((flag += 1))
done

echo ""

fnGetElapsedTime $LogNamePre $Total_Messages | tee -a $LogDirPre/console.log

exit $RET_OK

