#! /bin/sh
#---------------------------------------------------------
# Delete Messages
#
# Arguments:
# $1 : Queue manager name
# Read <QMGR>.mqsc from current directory
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#
#---------------------------------------------------------
# return code
RET_OK=0
RET_NG=1

#------------------------------------------------------------------
# Functions for deleting all messages
#
# input:
# $TARGET_QMGR:  Queue Manager Name
# ${TARGET_QMGR}.mqsc.src:  MQSC source file
#------------------------------------------------------------------
function fnDltMessages
{
  sourcefile=${TARGET_QMGR}.mqsc

  if [[ ! -f $sourcefile ]]
  then
    echo "Cannot find source file $sourcefile"
    return $RET_NG
  fi

  for que in `awk -F[\(\)] '$1 ~ /^[^\*]*def ql/ {print $2}' ${TARGET_QMGR}.mqsc`
  do
    echo "mqpgf -qm ${TARGET_QMGR} -q $que -r"
    mqpgf -qm ${TARGET_QMGR} -q $que -r
  done

  return $RET_OK
}

#-------
# Main
#-------
USAGE="usage: $0 <Qmgr>"

if (($# == 0))
then
  echo $USAGE
  exit $RET_NG
fi

TARGET_QMGR=${1}

# Delete Messages
fnDltMessages
exit $?

